/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.swing;

import frc.emul.api.IDevicesManager;
import frc.emul.api.ui.IDisplay;
import frc.emul.api.ui.IDisplayContext;
import frc.emul.api.ui.IFrameDelegate;
import frc.emul.api.ui.IUIContainer;
import frc.emul.config.Configuration;
import frc.emul.config.data.CfgItemChassis;
import frc.emul.config.data.CfgItemController;
import frc.emul.config.data.CfgItemGame;
import frc.emul.config.data.CfgItemKeymapping;
import frc.emul.config.data.CfgItemOptions;
import frc.emul.config.data.CfgItemShaderGlow;
import frc.emul.psg.IVectrexAudio;
import frc.emul.psg.dev.PsgRecording;
import frc.emul.psg.dev.ui.SamplesMonitor;
import frc.emul.standalone.CrashTracker;
import frc.emul.util.Utils;
import frc.emul.util.swing.FrameBoundsTracker;
import frc.emul.vectrex.PersistenceManager;
import frc.emul.vectrex.Vectrex;
import frc.emul.vectrex.swing.UIAbout;
import frc.emul.vectrex.swing.UIInOut;
import frc.emul.vectrex.swing.UIVersionChecker;
import frc.emul.vectrex.swing.UIWelcomePane;
import frc.emul.vectrex.swing.dev.UIGfxItemLimiter;
import frc.emul.vectrex.swing.menu.UIMenu;
import frc.emul.vectrex.ui.Browser;
import frc.emul.vectrex.ui.Timing;
import frc.emul.vectrex.ui.config.UIAnalogSettings;
import frc.emul.vectrex.ui.config.UIChassisSettings;
import frc.emul.vectrex.ui.config.UIDisplaySettings;
import frc.emul.vectrex.ui.config.UIFrameRate;
import frc.emul.vectrex.ui.config.UIGameSelector;
import frc.emul.vectrex.ui.config.UIGlowShaderSettings;
import frc.emul.vectrex.ui.config.UIKeyMapper;
import frc.emul.vectrex.ui.config.UIUtils;
import frc.emul.vectrex.ui.config.controller.UIJInputSettings;
import frc.emul.vectrex.ui.opengl.JoglContext;
import frc.emul.version.Version;
import frc.input.JInputController;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class UI {
    static final Method[] ctxMethods = IDisplayContext.class.getDeclaredMethods();
    private final Configuration config;
    private final IUIContainer uiContainer;
    private final Timing timing;
    private final UIMenu menu;
    private final UIInOut io;
    private int updatesLocked;
    private CrashTracker tracker;
    private FrameBoundsTracker boundsTracker;
    private IDisplay display;
    private UIFrameRate uiFrameRate;
    private boolean paused;
    private volatile boolean pausedEntered;

    public UI(final IDisplay iDisplay, Configuration configuration, CrashTracker crashTracker, IUIContainer iUIContainer) {
        if (iUIContainer == null) {
            iUIContainer = UI.createStandaloneContainer();
        }
        JPanel jPanel = new JPanel(new GridLayout(1, 0));
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.BLACK);
        iUIContainer.setUiComponent(jPanel);
        boolean bl = iUIContainer.isStandalone();
        this.uiContainer = iUIContainer;
        this.tracker = crashTracker;
        this.config = configuration;
        this.display = iDisplay;
        this.timing = new Timing(configuration.timing);
        this.menu = new UIMenu(this, bl, configuration);
        this.io = new UIInOut(this);
        JMenuBar jMenuBar = this.menu.getMenuBar();
        jMenuBar.setVisible(configuration.options.menuVisible);
        iUIContainer.setUiMenuBar(jMenuBar);
        JFrame jFrame = this.getWindow();
        if (bl) {
            jFrame.addWindowListener(new WindowAdapter(){
                private boolean attached;

                public synchronized void windowActivated(WindowEvent windowEvent) {
                    if (!this.attached) {
                        this.attached = true;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                UI.this.attachCanvas(iDisplay);
                            }
                        });
                    }
                }

                public synchronized void windowOpened(WindowEvent windowEvent) {
                    this.windowActivated(windowEvent);
                }

                public synchronized void windowClosing(WindowEvent windowEvent) {
                    UI.this.exit();
                }
            });
        } else {
            this.attachCanvas(iDisplay);
        }
        if (bl) {
            jFrame.setDefaultCloseOperation(0);
            boolean bl2 = configuration.options.display_fullscreen;
            if (bl2 && jFrame.getGraphicsConfiguration().getDevice().isFullScreenSupported()) {
                System.out.println("- Creating UI window (native fullscreen)");
                jFrame.setUndecorated(true);
                jFrame.getGraphicsConfiguration().getDevice().setFullScreenWindow(jFrame);
            } else if (bl2) {
                Rectangle rectangle = jFrame.getGraphicsConfiguration().getBounds();
                System.out.println("- Creating UI window (fullscreen fallback for " + rectangle + ")");
                jFrame.setUndecorated(true);
                jFrame.setAlwaysOnTop(true);
                jFrame.setBounds(rectangle);
                jFrame.setVisible(true);
            } else {
                boolean bl3 = configuration.options.display_rotation % 180 == 90;
                UIUtils.snapBounds(jFrame, configuration.window, bl3, configuration.options.menuVisible, false, false);
                int n = configuration.windowMaxState;
                System.out.println("- Creating UI window" + (n == 0 ? "" : " (state=" + n + ")"));
                this.boundsTracker = new FrameBoundsTracker(jFrame);
                jFrame.setExtendedState(n);
                jFrame.setVisible(true);
            }
        }
    }

    public void initialiseListeners(Vectrex vectrex) {
        this.menu.initialiseListeners(vectrex);
    }

    private final void attachCanvas(final IDisplay iDisplay) {
        final CfgItemKeymapping cfgItemKeymapping = this.config.keyMapping;
        final boolean bl = this.uiContainer.isStandalone();
        JComponent jComponent = this.uiContainer.getUiComponent();
        final Component component = iDisplay.getDisplayComponent();
        final boolean bl2 = this.getConfig().options.display_fullscreen && !this.getConfig().options.menuVisible;
        System.out.println("- Attaching GLCanvas to UI window");
        jComponent.removeAll();
        jComponent.add(component);
        jComponent.validate();
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (bl2) {
                        UIUtils.pushHiddenCursor(component);
                    }
                    iDisplay.getEventProducer().requestFocusInWindow();
                }
            });
        }
        component.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 154 && Utils.isWindowsOS()) {
                    this.keyPressed(keyEvent);
                }
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getModifiers() == 0) {
                    int n = keyEvent.getKeyCode();
                    if (n == cfgItemKeymapping.keyPause.getCode()) {
                        if (UI.this.isUsedByPeripherals(keyEvent)) {
                            return;
                        }
                        keyEvent.consume();
                        ((UI)UI.this).menu.miTogglePause.doClick(0);
                    }
                    if (n == cfgItemKeymapping.keySnapShot.getCode()) {
                        if (UI.this.isUsedByPeripherals(keyEvent)) {
                            return;
                        }
                        keyEvent.consume();
                        ((UI)UI.this).menu.miSnap.doClick(0);
                    } else if (n == cfgItemKeymapping.keyQuickSave.getCode()) {
                        if (UI.this.isUsedByPeripherals(keyEvent)) {
                            return;
                        }
                        keyEvent.consume();
                        ((UI)UI.this).menu.miQSave.doClick(0);
                    } else if (n == cfgItemKeymapping.keyQuickLoad.getCode()) {
                        if (UI.this.isUsedByPeripherals(keyEvent)) {
                            return;
                        }
                        keyEvent.consume();
                        ((UI)UI.this).menu.miQLoad.doClick(0);
                    } else if (n == cfgItemKeymapping.keySave.getCode()) {
                        if (UI.this.isUsedByPeripherals(keyEvent)) {
                            return;
                        }
                        keyEvent.consume();
                        ((UI)UI.this).menu.miSave.doClick(0);
                    } else if (n == cfgItemKeymapping.keyLoad.getCode()) {
                        if (UI.this.isUsedByPeripherals(keyEvent)) {
                            return;
                        }
                        keyEvent.consume();
                        ((UI)UI.this).menu.miLoad.doClick(0);
                    } else if (n == cfgItemKeymapping.keyMenu.getCode()) {
                        if (UI.this.isUsedByPeripherals(keyEvent)) {
                            return;
                        }
                        keyEvent.consume();
                        ((UI)UI.this).menu.miToggleMenu.doClick(0);
                    } else if (n == cfgItemKeymapping.keySizeOptim.getCode()) {
                        if (UI.this.isUsedByPeripherals(keyEvent)) {
                            return;
                        }
                        keyEvent.consume();
                        ((UI)UI.this).menu.miOptimizeSize.doClick(0);
                    } else if (n == cfgItemKeymapping.keyReset.getCode()) {
                        if (UI.this.isUsedByPeripherals(keyEvent)) {
                            return;
                        }
                        keyEvent.consume();
                        ((UI)UI.this).menu.miReset.doClick(0);
                    } else if (n == cfgItemKeymapping.keyExit.getCode() && bl) {
                        if (UI.this.isUsedByPeripherals(keyEvent)) {
                            return;
                        }
                        keyEvent.consume();
                        ((UI)UI.this).menu.miExit.doClick(0);
                    } else if (n == 121 && Utils.isWindowsOS()) {
                        if (UI.this.isUsedByPeripherals(keyEvent)) {
                            return;
                        }
                        keyEvent.consume();
                    }
                }
            }
        });
    }

    public static IUIContainer createStandaloneContainer() {
        return new IUIContainer(){
            private JComponent comp;
            private JFrame frame;
            private JMenuBar menuBar;

            public JFrame getApplicationFrame() {
                if (this.frame == null) {
                    String string = "ParaJVE v" + Version.sSHORT;
                    this.frame = new JFrame(string);
                    URL uRL = Thread.currentThread().getContextClassLoader().getResource("frc/emul/vectrex/images/iconSpike.png");
                    this.frame.setIconImage(new ImageIcon(uRL).getImage());
                    this.frame.setBackground(Color.BLACK);
                }
                return this.frame;
            }

            public boolean isStandalone() {
                return true;
            }

            public void setUiMenuBar(JMenuBar jMenuBar) {
                this.menuBar = jMenuBar;
                this.getApplicationFrame().setJMenuBar(jMenuBar);
            }

            public void setUiComponent(JComponent jComponent) {
                this.comp = jComponent;
                Container container = this.getApplicationFrame().getContentPane();
                container.add((Component)jComponent, "Center");
                container.validate();
                container.repaint();
            }

            public JComponent getUiComponent() {
                return this.comp;
            }

            public JMenuBar getMenuBar() {
                return this.menuBar;
            }

            public IFrameDelegate createFrame(Object object) {
                throw new UnsupportedOperationException("ParaJVE does not implement IUIContainer.createFrame() yet!");
            }
        };
    }

    private final boolean isUsedByPeripherals(KeyEvent keyEvent) {
        IDevicesManager iDevicesManager;
        try {
            iDevicesManager = this.getPeripherals();
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return iDevicesManager.getPort(1).consumes(keyEvent) || iDevicesManager.getPort(0).consumes(keyEvent);
    }

    public boolean isSoundEnabled() {
        return this.getConfig().options.snd_enabled;
    }

    public void toggleSound() {
        boolean bl = !this.getAudio().isSoundEnabled();
        this.getAudio().setSoundEnabled(bl);
        this.getConfig().options.snd_enabled = bl;
        this.getConfig().setDirty(true);
    }

    public boolean isSoundChannelMuted(int n) {
        return this.getAudio().isChannelMuted(n);
    }

    public void toggleSoundChannelMuted(int n) {
        boolean bl = !this.getAudio().isChannelMuted(n);
        this.getAudio().setChannelMuted(n, bl);
    }

    public int getSoundSamplingFreq() {
        return (Integer)this.getAttrValue(Attr.SND_SAMPLING_FREQ);
    }

    public void setSoundSamplingFreq(int n) {
        this.setAttrValue(Attr.SND_SAMPLING_FREQ, n);
    }

    public float getSoundVolume() {
        return ((Float)this.getAttrValue(Attr.SND_VOLUME)).floatValue();
    }

    public void setSoundVolume(float f) {
        this.setAttrValue(Attr.SND_VOLUME, Float.valueOf(Math.max(0.0f, Math.min(1.0f, f))));
    }

    public boolean isAntiAliasEnabled() {
        return (Boolean)this.getAttrValue(Attr.ANTIALIAS_ENABLED);
    }

    public void toggleAntiAlias() {
        this.toggleAttrValue(Attr.ANTIALIAS_ENABLED, true);
    }

    public boolean isAdditiveBlendingEnabled() {
        return (Boolean)this.getAttrValue(Attr.ADDITIVE_BLENDING);
    }

    public void toggleAdditiveBlending() {
        this.toggleAttrValue(Attr.ADDITIVE_BLENDING, true);
    }

    public float getPointsSize() {
        return ((Float)this.getAttrValue(Attr.POINTS_SIZE)).floatValue();
    }

    public void setPointsSize(float f) {
        this.setAttrValue(Attr.POINTS_SIZE, Float.valueOf(f));
    }

    public float getLinesThickness() {
        return ((Float)this.getAttrValue(Attr.LINES_THICKNESS)).floatValue();
    }

    public void setLinesThickness(float f) {
        this.setAttrValue(Attr.LINES_THICKNESS, Float.valueOf(f));
    }

    public float getWobblingFactor() {
        return ((Float)this.getAttrValue(Attr.WOBBLING_FACTOR)).floatValue();
    }

    public void setWobblingFactor(float f) {
        this.setAttrValue(Attr.WOBBLING_FACTOR, Float.valueOf(f));
    }

    public boolean isWobblingEnabled() {
        return (Boolean)this.getAttrValue(Attr.WOBBLING_ENABLED);
    }

    public void toggleWobbling() {
        this.toggleAttrValue(Attr.WOBBLING_ENABLED, false);
    }

    public boolean isPersistenceAllowed() {
        return this.getDisplayContext().isPersistenceAllowed();
    }

    public boolean isPersistenceEnabled() {
        return (Boolean)this.getAttrValue(Attr.PERSISTENCE_ENABLED);
    }

    public void togglePersistence() {
        if (this.isPersistenceAllowed()) {
            this.toggleAttrValue(Attr.PERSISTENCE_ENABLED, true);
        }
    }

    public boolean isGlowShaderBlocked() {
        return this.getDisplayContext().isGlowShaderBlocked();
    }

    public boolean isGlowShaderEnabled() {
        return (Boolean)this.getAttrValue(Attr.GLOW_SHADER_ENABLED);
    }

    public void toggleGlowShader() {
        this.toggleAttrValue(Attr.GLOW_SHADER_ENABLED, true);
    }

    public boolean isChassisEnabled() {
        return (Boolean)this.getAttrValue(Attr.CHASSIS_ENABLED);
    }

    public void toggleChassis() {
        this.toggleAttrValue(Attr.CHASSIS_ENABLED, true);
    }

    public boolean isOverlayEnabled() {
        return (Boolean)this.getAttrValue(Attr.OVERLAY_ENABLED);
    }

    public void toggleOverlay() {
        this.toggleAttrValue(Attr.OVERLAY_ENABLED, true);
    }

    public boolean isFullViewport() {
        return (Boolean)this.getAttrValue(Attr.FULL_VIEWPORT);
    }

    public void toggleFullViewport() {
        this.toggleAttrValue(Attr.FULL_VIEWPORT, true);
    }

    public int getOverlayMode() {
        return (Integer)this.getAttrValue(Attr.OVERLAY_MODE);
    }

    public void setOverlayMode(int n) {
        this.setAttrValue(Attr.OVERLAY_MODE, n);
    }

    public float getBrightnessFactor() {
        return ((Float)this.getAttrValue(Attr.BRIGHTNESS_FACTOR)).floatValue();
    }

    public void setBrightnessFactor(float f) {
        this.setAttrValue(Attr.BRIGHTNESS_FACTOR, Float.valueOf(f));
    }

    public float getGammaCorrection() {
        return ((Float)this.getAttrValue(Attr.GAMMA_CORRECTION)).floatValue();
    }

    public void setGammaCorrection(float f) {
        this.setAttrValue(Attr.GAMMA_CORRECTION, Float.valueOf(f));
    }

    public boolean isDebugRefGridDrawn() {
        return (Boolean)this.getAttrValue(Attr.DEBUG_REF_GRID);
    }

    public void toggleDebugRefGrid() {
        this.toggleAttrValue(Attr.DEBUG_REF_GRID, true);
    }

    public boolean isFpsDrawn() {
        return (Boolean)this.getAttrValue(Attr.DEBUG_FPS_DRAWN);
    }

    public void toggleFps() {
        this.toggleAttrValue(Attr.DEBUG_FPS_DRAWN, true);
    }

    public int getDisplayRotation() {
        return (Integer)this.getAttrValue(Attr.DISPLAY_ROTATION);
    }

    public void setDisplayRotation(int n) {
        this.setAttrValue(Attr.DISPLAY_ROTATION, n, false);
        Component component = this.getDisplay().getDisplayComponent();
        component.setBounds(component.getX(), component.getY(), component.getWidth(), component.getHeight());
        this.updateRendering();
    }

    public float getChassisZoomFactor() {
        return ((Float)this.getAttrValue(Attr.CHASSIS_ZOOM)).floatValue();
    }

    public void setChassisZoomFactor(float f, boolean bl) {
        this.setAttrValue(Attr.CHASSIS_ZOOM, Float.valueOf(f), !bl);
        if (bl) {
            this.setChassisZoomOffsets(0.0f, JoglContext.computeOptimalChassisOffset(this.getDisplayContext().getChassisSettings().zoom));
        }
    }

    public void setChassisZoomOffsets(float f, float f2) {
        this.setAttrValue(Attr.CHASSIS_OFFSET_X, Float.valueOf(f), false);
        this.setAttrValue(Attr.CHASSIS_OFFSET_Y, Float.valueOf(f2), true);
    }

    public void optimizeWindowSize() {
        CfgItemOptions cfgItemOptions = this.getConfig().options;
        boolean bl = cfgItemOptions.display_rotation % 180 == 90;
        JFrame jFrame = this.getWindow();
        UIUtils.snapBounds(jFrame, jFrame.getBounds(), bl, cfgItemOptions.menuVisible, true, true);
    }

    public void toggleMenu() {
        boolean bl;
        Configuration configuration = this.getConfig();
        CfgItemOptions cfgItemOptions = configuration.options;
        boolean bl2 = bl = !cfgItemOptions.menuVisible;
        if (!bl && cfgItemOptions.hideMenuHelp) {
            JCheckBox jCheckBox = new JCheckBox("Do not show this help message again");
            String string = Utils.encodeHTML(configuration.keyMapping.keyMenu.getString(true), false).toString();
            JLabel jLabel = new JLabel("<html>The menu bar will now be hidden.<br>To make it visible again, press the '<b>" + string + "</b>' key.&nbsp;&nbsp;&nbsp;<br>&nbsp;<br>");
            JOptionPane.showMessageDialog(this.getWindow(), new Object[]{jLabel, new JSeparator(), jCheckBox}, "ParaJVE - Hide Menu...", 1);
            if (jCheckBox.isSelected()) {
                cfgItemOptions.hideMenuHelp = false;
                configuration.setDirty(true);
            }
        }
        this.menu.getMenuBar().setVisible(bl);
        if (cfgItemOptions.display_fullscreen) {
            if (bl) {
                UIUtils.popHiddenCursor(this.getDisplay().getDisplayComponent());
            } else {
                UIUtils.pushHiddenCursor(this.getDisplay().getDisplayComponent());
            }
        }
        cfgItemOptions.menuVisible = bl;
        configuration.setDirty(true);
    }

    public void waitEndOfPause() {
        if (this.paused) {
            while (this.paused) {
                this.pausedEntered = true;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean bl) {
        if (bl != this.paused) {
            this.pausedEntered = false;
            this.paused = bl;
            String string = this.getWindow().getTitle();
            String string2 = " -- Paused";
            if (bl) {
                while (!this.pausedEntered) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.getWindow().setTitle(String.valueOf(string) + string2);
            } else {
                this.getWindow().setTitle(string.substring(0, string.indexOf(string2)));
            }
        }
        this.menu.miTogglePause.setSelected(bl);
    }

    public void reset() {
        this.setPaused(true);
        Vectrex.INSTANCE.reset();
        this.setPaused(false);
    }

    public void about() {
        new UIAbout().open(this.getWindow());
    }

    public void welcome() {
        boolean bl;
        boolean bl2 = bl = !this.isPaused();
        if (bl) {
            this.setPaused(true);
        }
        UIWelcomePane.open(this.getWindow(), this.getConfig());
        if (bl) {
            this.setPaused(false);
        }
    }

    public void checkNewVersion() {
        new Thread(){

            public void run() {
                UIVersionChecker.check(UI.this.getWindow(), Version.getVersionDescriptorURL());
            }
        }.start();
    }

    public void openAudioMonitor() {
        SamplesMonitor.monitorPSG(this.getAudio().getPSG());
    }

    public void openGfxItemLimiter() {
        UIGfxItemLimiter.openSettingsEditor(this.getWindow(), this.display);
    }

    public void showTemporaryMessage(String string) {
    }

    public void browseBlog() {
        Browser.displayURL(Version.getDevBlogInternalURL(), true);
    }

    public void browseReleaseNotes() {
        Browser.displayURL(Version.getLocalReleaseNotesURL(), true);
    }

    public void browseUserGuide() {
        Browser.displayURL(Version.getLocalUserGuideURL(), true);
    }

    public void browseGameDoc() {
        URL uRL = this.getConfig().getSelectedGame().getDocURL();
        if (uRL != null) {
            Browser.displayURL(uRL.toExternalForm(), true);
        }
    }

    public void exit() {
        try {
            if (this.boundsTracker != null) {
                if (this.boundsTracker.hasBoundsChanged()) {
                    this.getConfig().window.setBounds(this.boundsTracker.getNormalBounds());
                    this.getConfig().setDirty(true);
                }
                if (this.boundsTracker.getMaximizedState() != this.getConfig().windowMaxState) {
                    this.getConfig().windowMaxState = this.boundsTracker.getMaximizedState();
                    this.getConfig().setDirty(true);
                }
            }
            if (this.getConfig().isDirty()) {
                this.getConfig().save();
            }
            System.out.println("Shutdown...");
            if (this.tracker != null) {
                this.tracker.shutdown();
            }
            PsgRecording.INSTANCE.saveRecords(String.valueOf(UI.getDataDevRoot()) + "/sfx/" + this.getConfig().getSelectedGame().getID() + ".txt");
            this.getPeripherals().shutdown();
        }
        finally {
            if (this.uiContainer.isStandalone()) {
                System.out.println("Exiting ParaJVE...");
                System.exit(0);
            }
        }
    }

    public void selectFPS() {
        if (this.uiFrameRate == null) {
            this.uiFrameRate = new UIFrameRate();
        }
        this.uiFrameRate.openSelector(this.getWindow(), this);
    }

    public boolean isFpsSelectorOpened() {
        return this.uiFrameRate != null && this.uiFrameRate.isOpened();
    }

    public void editKeyMapping() {
        boolean bl;
        boolean bl2 = bl = !this.paused;
        if (bl) {
            this.setPaused(true);
        }
        try {
            final Configuration configuration = this.getConfig();
            UIKeyMapper uIKeyMapper = new UIKeyMapper(){

                public void configChanged() {
                    configuration.setDirty(true);
                    UI.this.menu.keyMappingChanged();
                }
            };
            uIKeyMapper.openSettingsEditor(this.getWindow(), configuration, this.uiContainer.isStandalone());
            UIKeyMapper.applyConfig(configuration);
        }
        finally {
            if (bl) {
                this.setPaused(false);
            }
        }
    }

    public CfgItemController editControllerSettings(JInputController jInputController) {
        boolean bl;
        boolean bl2 = bl = !this.paused;
        if (bl) {
            this.setPaused(true);
        }
        try {
            Configuration configuration = this.getConfig();
            UIJInputSettings uIJInputSettings = new UIJInputSettings();
            CfgItemController cfgItemController = uIJInputSettings.editControllerSettings(this.getWindow(), jInputController, configuration);
            if (cfgItemController != null) {
                configuration.setDirty(true);
                UIKeyMapper.applyConfig(configuration);
            }
            CfgItemController cfgItemController2 = cfgItemController;
            return cfgItemController2;
        }
        finally {
            if (bl) {
                this.setPaused(false);
            }
        }
    }

    public void editAnalogSettings() {
        UIAnalogSettings uIAnalogSettings = new UIAnalogSettings(){

            public void configChanged() {
                UI.this.getConfig().setDirty(true);
            }
        };
        uIAnalogSettings.openSettingsEditor(this.getWindow(), this.config.keyMapping);
    }

    public void editChassisSettings() {
        UIChassisSettings uIChassisSettings = new UIChassisSettings(){

            public void configChanged() {
                UI.this.getConfig().options.chassis = UI.this.getDisplayContext().getChassisSettings().clone();
                UI.this.getConfig().setDirty(true);
            }
        };
        uIChassisSettings.openSettingsEditor(this.getWindow(), this);
    }

    public void editMiscDisplaySettings() {
        new UIDisplaySettings().openSettingsEditor(this.getWindow(), this);
    }

    public void editOverlaySettings() {
        JOptionPane.showMessageDialog(this.getWindow(), "Not yet implemented");
    }

    public void editGlowShaderSettings() {
        UIGlowShaderSettings uIGlowShaderSettings = new UIGlowShaderSettings(this.getDisplayContext().getGlowShader()){

            protected void shaderChanged(CfgItemShaderGlow cfgItemShaderGlow) {
                UI.this.getDisplayContext().updateGlowShader(cfgItemShaderGlow);
                UI.this.updateRendering();
            }

            protected void shaderAccepted(CfgItemShaderGlow cfgItemShaderGlow) {
                UI.this.getConfig().options.glowShader.clone(cfgItemShaderGlow, false);
                UI.this.getConfig().setDirty(true);
            }

            protected void windowClosed() {
                ((UI)UI.this).menu.miShaderProfile.setEnabled(true);
            }
        };
        this.menu.miShaderProfile.setEnabled(false);
        uIGlowShaderSettings.openEditor(this.getWindow());
    }

    public void selectShaderProfile() {
        UIGlowShaderSettings uIGlowShaderSettings = new UIGlowShaderSettings(this.getDisplayContext().getGlowShader()){

            protected void shaderChanged(CfgItemShaderGlow cfgItemShaderGlow) {
                UI.this.getDisplayContext().updateGlowShader(cfgItemShaderGlow);
                UI.this.updateRendering();
            }

            protected void shaderAccepted(CfgItemShaderGlow cfgItemShaderGlow) {
                UI.this.getConfig().options.glowShader.clone(cfgItemShaderGlow, false);
                UI.this.getConfig().setDirty(true);
            }

            protected void windowClosed() {
                ((UI)UI.this).menu.miShaderSettings.setEnabled(true);
            }
        };
        this.menu.miShaderSettings.setEnabled(false);
        uIGlowShaderSettings.openSelector(this.getWindow(), this.getConfig().options.glowShader);
    }

    public void switchGame() {
        new Thread("ParaJVE - Game Selection"){

            public void run() {
                boolean bl;
                boolean bl2 = bl = !UI.this.isPaused();
                if (bl) {
                    UI.this.setPaused(true);
                }
                long l = UI.this.getConfig().getSelectedGame().info.getBinaryCRC32();
                UIGameSelector uIGameSelector = new UIGameSelector();
                CfgItemGame cfgItemGame = uIGameSelector.chooseGame(UI.this.getWindow(), UI.this.getConfig(), false);
                if (cfgItemGame == null || !cfgItemGame.cartridge.built && l == cfgItemGame.info.getBinaryCRC32() || !UIInOut.loadCartridge(UI.this.getWindow(), cfgItemGame, true)) {
                    if (bl) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                UI.this.setPaused(false);
                            }
                        });
                    }
                    return;
                }
                UI.this.getConfig().setSelectedGame(cfgItemGame);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        UI.this.reset();
                    }
                });
            }
        }.start();
    }

    public void quickSave() {
        File file = this.io.saveImpl(PersistenceManager.SaveType.QUICK, this.io.getQuickStorageProvider(false), "Quick Save", null);
        if (file != null) {
            this.showTemporaryMessage("Quick Save successfully completed");
        }
    }

    public void save() {
        File file = this.io.saveImpl(PersistenceManager.SaveType.USER, this.io.getSaveProvider(), "Save...", "Current game state successfully saved.");
        if (file != null) {
            this.showTemporaryMessage("Game state successfully saved");
        }
    }

    public void quickLoad() {
        this.io.loadImpl(this.io.getQuickStorageProvider(true));
    }

    public void load() {
        this.io.loadImpl(this.io.getLoadProvider());
    }

    public void reloadRoms() {
        this.io.reloadRomsImpl();
    }

    public void injectRamInCartridge() {
        this.io.injectRamInCartridgeImpl();
    }

    public void snapshot() {
        this.io.snapshotImpls();
    }

    public final IDisplay getDisplay() {
        return this.display;
    }

    public final IDisplayContext getDisplayContext() {
        return this.getDisplay().getContext();
    }

    public final void updateRendering() {
        if (this.updatesLocked <= 0) {
            this.getDisplay().updateRendering();
        }
    }

    public final void lockUpdates() {
        ++this.updatesLocked;
    }

    public final void unlockUpdates() {
        --this.updatesLocked;
    }

    public final void updateAudio() {
        this.getAudio().updateSettings();
    }

    public final IVectrexAudio getAudio() {
        return Vectrex.INSTANCE.getAudio();
    }

    public final IDevicesManager getPeripherals() {
        return Vectrex.INSTANCE.getPeripherals();
    }

    public final Configuration getConfig() {
        return this.config;
    }

    public final Timing getTiming() {
        return this.timing;
    }

    public final JFrame getWindow() {
        return this.uiContainer.getApplicationFrame();
    }

    public static final String getDataDevRoot() {
        try {
            if (new File("./data-dev").isDirectory()) {
                return "data-dev";
            }
        }
        catch (Exception exception) {}
        return "data";
    }

    private Object getAttrValue(Attr attr) {
        return attr.hasCtxAccess() ? attr.getCtxValue(this.getDisplayContext()) : attr.getAttrValue(this.getConfig());
    }

    private void setAttrValue(Attr attr, Object object) {
        this.setAttrValue(attr, object, true);
    }

    private void setAttrValue(Attr attr, Object object, boolean bl) {
        if (attr.hasCtxAccess()) {
            IDisplayContext iDisplayContext = this.getDisplayContext();
            attr.setCtxValue(iDisplayContext, object);
            object = attr.getCtxValue(iDisplayContext);
        } else if (object.equals(this.getAttrValue(attr))) {
            return;
        }
        attr.setAttrValue(this.getConfig(), object);
        this.getConfig().setDirty(true);
        if (bl) {
            switch (attr.getType()) {
                case AUDIO: {
                    this.updateAudio();
                    break;
                }
                case GFX: {
                    this.updateRendering();
                }
            }
        }
    }

    private void toggleAttrValue(Attr attr, boolean bl) {
        IDisplayContext iDisplayContext = this.getDisplayContext();
        this.setAttrValue(attr, (Boolean)attr.getCtxValue(iDisplayContext) == false, bl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Attr {
        ADDITIVE_BLENDING(AttrType.GFX, "AdditiveBlendingEnabled", "display_additive_blend"),
        ANTIALIAS_ENABLED(AttrType.GFX, "AntiAliasEnabled", "display_antialiasing"),
        BRIGHTNESS_FACTOR(AttrType.GFX, "BrightnessFactor", "display_brightness"),
        CHASSIS_ENABLED(AttrType.GFX, "ChassisEnabled", "enabled", CfgItemChassis.class),
        CHASSIS_OFFSET_X(AttrType.GFX, "ChassisOffsetX", "xOffset", CfgItemChassis.class),
        CHASSIS_OFFSET_Y(AttrType.GFX, "ChassisOffsetY", "yOffset", CfgItemChassis.class),
        CHASSIS_ZOOM(AttrType.GFX, "ChassisZoom", "zoom", CfgItemChassis.class),
        DEBUG_FPS_DRAWN(AttrType.GFX, "FpsDrawn", "showFps"),
        DEBUG_REF_GRID(AttrType.GFX, "DebugRefGridDrawn"),
        DISPLAY_ROTATION(AttrType.GFX, "Rotation", "display_rotation"),
        FULL_VIEWPORT(AttrType.GFX, "FullViewport", "display_full_viewport"),
        GAMMA_CORRECTION(AttrType.GFX, "GammaCorrection", "display_gamma"),
        GLOW_SHADER_ENABLED(AttrType.GFX, "GlowShaderEnabled", "active", CfgItemShaderGlow.class),
        LINES_THICKNESS(AttrType.GFX, "LinesSize", "display_size_lines"),
        OVERLAY_ENABLED(AttrType.GFX, "OverlayEnabled", "display_overlay"),
        OVERLAY_MODE(AttrType.GFX, "OverlayMode", "display_overlay_mode"),
        PERSISTENCE_ENABLED(AttrType.GFX, "PersistenceEnabled", "display_persistence"),
        POINTS_SIZE(AttrType.GFX, "PointsSize", "display_size_points"),
        WOBBLING_ENABLED(AttrType.GFX, "WobblingEnabled", "display_wobbling"),
        WOBBLING_FACTOR(AttrType.GFX, "WobblingFactor", "display_wobbling_factor"),
        SND_SAMPLING_FREQ(AttrType.AUDIO, null, "snd_samplingFreq"),
        SND_VOLUME(AttrType.AUDIO, null, "snd_volume");

        private static final Object[] EMPTY;
        private final int getterIdx;
        private final int setterIdx;
        private final Class<?> attrClass;
        private final Field attrField;
        private final AttrType type;

        static {
            EMPTY = new Object[0];
        }

        private Attr(AttrType attrType, String string2) {
            this(attrType, string2, null, null);
        }

        private Attr(AttrType attrType, String string2, String string3) {
            this(attrType, string2, string3, CfgItemOptions.class);
        }

        private Attr(AttrType attrType, String string2, String string3, Class<?> clazz) {
            int n2 = this.setterIdx = string2 == null ? -1 : Attr.getMethodIndex("set" + string2);
            this.getterIdx = string2 == null ? -1 : Attr.getMethodIndex(String.valueOf(Boolean.TYPE.equals(ctxMethods[this.setterIdx].getParameterTypes()[0]) ? "is" : "get") + string2);
            this.attrClass = clazz;
            try {
                this.attrField = string3 == null ? null : clazz.getDeclaredField(string3);
            }
            catch (Exception exception) {
                throw new RuntimeException("Cannot find field \"" + string3 + "\" in " + clazz);
            }
            this.type = attrType;
        }

        public boolean hasCtxAccess() {
            return this.setterIdx >= 0;
        }

        public AttrType getType() {
            return this.type;
        }

        public Object getCtxValue(IDisplayContext iDisplayContext) {
            try {
                return ctxMethods[this.getterIdx].invoke((Object)iDisplayContext, EMPTY);
            }
            catch (Exception exception) {
                throw new RuntimeException("Error while invoking display context's getter [" + ctxMethods[this.getterIdx] + "]", exception);
            }
        }

        public void setCtxValue(IDisplayContext iDisplayContext, Object object) {
            try {
                ctxMethods[this.setterIdx].invoke((Object)iDisplayContext, object);
            }
            catch (Exception exception) {
                throw new RuntimeException("Error while invoking display context's setter [" + ctxMethods[this.setterIdx] + "] with value [" + object + "]", exception);
            }
        }

        public void setAttrValue(Configuration configuration, Object object) {
            Object object2 = this.getAttrConfigTarget(configuration);
            if (object2 != null) {
                try {
                    this.attrField.set(object2, object);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Error while setting value [" + object + "] in attribute [" + this.attrField + "] of object [" + object2 + "]", exception);
                }
            }
        }

        public Object getAttrValue(Configuration configuration) {
            Object object = this.getAttrConfigTarget(configuration);
            if (object != null) {
                try {
                    return this.attrField.get(object);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Error while getting value in attribute [" + this.attrField + "] of object [" + object + "]", exception);
                }
            }
            return null;
        }

        private final Object getAttrConfigTarget(Configuration configuration) {
            if (this.attrClass != null && this.attrField != null) {
                if (this.attrClass == CfgItemOptions.class) {
                    return configuration.options;
                }
                if (this.attrClass == CfgItemShaderGlow.class) {
                    return configuration.options.glowShader;
                }
                if (this.attrClass == CfgItemChassis.class) {
                    return configuration.options.chassis;
                }
                throw new RuntimeException("Unsupported attribute target " + this.attrClass);
            }
            return null;
        }

        private static final int getMethodIndex(String string) {
            Method[] methodArray = ctxMethods;
            int n = methodArray.length;
            while (n-- > 0) {
                if (!string.equals(methodArray[n].getName())) continue;
                return n;
            }
            throw new RuntimeException("Cannot find method \"" + string + "\" in " + IDisplayContext.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AttrType {
        GFX,
        AUDIO;

    }
}

